function [int]=integral1( f, df, w, dw, xa, xb)
%
% function [int]=integral1( f, df, w, dw, xa, xb)
%
% Funcion auxiliar definida para demostracion del metodo de Galerkin
% aplicado a funciones continuas a trozos.
%
% ENTRADA
%
% f, df     funcion test y derivada de la funcion test
% w, dw     funcion peso y derivada de la funcion peso
% xa, xb    limites de integracion
%
% SALIDA
%
%  int      valor de la integral
%
Lfw = @(x) -dw(x).*df(x)-w(x).*f(x) ;
I1  = quad(Lfw, xa, xb);
int = I1 + w(xb).*df(xb) - w(xa).*df(xa);